<?php
/**
 * ===================================================================================
 * Reset Super Admin Password (One-Time Use) - v2 (with better debugging)
 * ===================================================================================
 *
 * File: reset_admin_password.php
 * Location: /homework_portal/admin/reset_admin_password.php
 *
 * --- IMPORTANT ---
 * This script is for password recovery only. You MUST delete this file from your
 * server immediately after you run it successfully.
 */

require_once '../config.php';

// The credentials we want to set
$username_to_reset = 'admin';
$new_password = 'admin1234';

echo "<h1>Admin Password Reset Script v2</h1>";

// 1. Check for database connection
if (!$pdo) {
    die("<h2 style='color:red;'>FATAL ERROR: Could not connect to the database. Check your config.php file.</h2>");
}
echo "<p>Database connection successful.</p>";

// 2. Check if the admin user actually exists
try {
    $stmt = $pdo->prepare("SELECT id FROM super_admins WHERE username = ?");
    $stmt->execute([$username_to_reset]);
    $admin_user = $stmt->fetch();

    if (!$admin_user) {
         die("<h2 style='color:red;'>ERROR: The admin user '{$username_to_reset}' does not exist in the 'super_admins' table.</h2><p>Please run the 'create_admin.php' script first, then delete this file.</p>");
    }
    echo "<p>Admin user '{$username_to_reset}' found in the database.</p>";

} catch (PDOException $e) {
    die("<h2 style='color:red;'>DATABASE ERROR during user check: " . $e->getMessage() . "</h2>");
}


// 3. Generate the new password hash
$new_password_hash = password_hash($new_password, PASSWORD_DEFAULT);
echo "<p>Generated new password hash: " . htmlspecialchars($new_password_hash) . "</p>";


// 4. Prepare and execute the UPDATE statement
$sql = "UPDATE super_admins SET password_hash = ? WHERE username = ?";
echo "<p>Attempting to update the password...</p>";

try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$new_password_hash, $username_to_reset]);

    // 5. Verify that the update was successful
    if ($stmt->rowCount() > 0) {
        echo "<h2>Success!</h2>";
        echo "<p>The password for admin user '<b>{$username_to_reset}</b>' has been reset in the database.</p>";
        echo "<p>Your new password is: '<b>{$new_password}</b>'.</p>";
        echo "<p style='color: red; font-weight: bold; font-size: 1.2em;'>You can now try logging in. After you log in successfully, you MUST delete this 'reset_admin_password.php' file from your server.</p>";
    } else {
        echo "<h2>Warning!</h2>";
        echo "<p>The script ran, but no rows in the database were changed. This is unusual. Please check the username '<b>{$username_to_reset}</b>' and the table name.</p>";
        echo "<p style='color: red; font-weight: bold;'>Please delete this file from your server now.</p>";
    }

} catch (PDOException $e) {
    echo "<h2>Error!</h2>";
    echo "<p>Could not reset the password due to a database error: " . $e->getMessage() . "</p>";
}

?>
